--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: -
--


SET search_path = public, pg_catalog;

--
-- Name: update_ct_workflow_comment(); Type: FUNCTION; Schema: public; Owner: -
--

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: pt_current; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pt_current;
CREATE TABLE pt_current (
  office_cdoe character varying(4) NOT NULL,
  calc_type smallint DEFAULT 0 NOT NULL,
  calc_date date NOT NULL, 
  current_status smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL, 
  update_date timestamp without time zone NOT NULL, 
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (office_cdoe,calc_type,calc_date)
);

--
-- Name: TABLE pt_current; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pt_current IS '計算年月テーブル';

--
-- Name: COLUMN pt_current.office_cdoe; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.office_cdoe IS '事業所コード';

--
-- Name: COLUMN pt_current.calc_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.calc_type IS '計算区分';

--
-- Name: COLUMN pt_current.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.calc_date IS '計算年月';

--
-- Name: COLUMN pt_current.current_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.current_status IS '計算状態';

--
-- Name: COLUMN pt_current.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.insert_date IS '作成日';

--
-- Name: COLUMN pt_current.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.insert_user IS '作成者';

--
-- Name: COLUMN pt_current.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.update_date IS '更新日';

--
-- Name: COLUMN pt_current.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pt_current.update_user IS '更新者';



DROP TABLE IF EXISTS pm_code;
CREATE TABLE pm_code (
  code_id character varying(8) NOT NULL,
  code_code character varying(4) NOT NULL,
  code_name character varying(32) NOT NULL,
  code_abbr character varying(8) NOT NULL,
  view_index smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (code_id,code_code)
);

--
-- Name: TABLE pm_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_code IS '給与用コードマスタ';

--
-- Name: COLUMN pm_code.code_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.code_id IS 'コードID';

--
-- Name: COLUMN pm_code.code_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.code_code IS 'コード';

--
-- Name: COLUMN pm_code.code_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.code_name IS 'コード名称';

--
-- Name: COLUMN pm_code.code_abbr; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.code_abbr IS 'コード略称';

--
-- Name: COLUMN pm_code.view_index; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.view_index IS '表示順';

--
-- Name: COLUMN pm_code.delete_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.delete_flag IS '削除フラグ';

--
-- Name: COLUMN pm_code.edit_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN pm_code.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.insert_date IS '作成日';

--
-- Name: COLUMN pm_code.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.insert_user IS '作成者';

--
-- Name: COLUMN pm_code.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.update_date IS '更新日';

--
-- Name: COLUMN pm_code.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pm_code.update_user IS '更新者';

DROP TABLE IF EXISTS ph_payment;
CREATE TABLE ph_payment (
  kcode character varying(10) NOT NULL,
  calc_month date NOT NULL,
  pay_date date NOT NULL,
  slip_code character varying(8) NOT NULL,
  allowance_total integer NOT NULL default 0,
  deduction_total integer NOT NULL default 0,
  payment_total integer NOT NULL default 0,
  taxation integer NOT NULL default 0,
  soc_ins_total integer NOT NULL default 0,
  dependent smallint NOT NULL default 0,
  income_tax integer NOT NULL default 0,
  adjusted_tax integer NOT NULL default 0,
  insure_money integer NOT NULL default 0,
  insure_in_kind integer NOT NULL default 0,
  insure_fixed integer NOT NULL default 0,
  insure_unemploy integer NOT NULL default 0,
  bonus_base integer NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_month)
);
--
-- Name: TABLE ph_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ph_payment IS '給与ヘッダー';

--
-- Name: COLUMN ph_payment.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.kcode IS '社員コード';

--
-- Name: COLUMN ph_payment.calc_month; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.calc_month IS '計算年月';

--
-- Name: COLUMN ph_payment.pay_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.pay_date IS '支給日';

--
-- Name: COLUMN ph_payment.slip_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.slip_code IS '伝票コード';

--
-- Name: COLUMN ph_payment.allowance_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.allowance_total IS '総支給金額';

--
-- Name: COLUMN ph_payment.deduction_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.deduction_total IS '総控除金額';

--
-- Name: COLUMN ph_payment.payment_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.payment_total IS '差引支給額';

--
-- Name: COLUMN ph_payment.taxation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.taxation IS '課税支給額';

--
-- Name: COLUMN ph_payment.soc_ins_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.soc_ins_total IS '社会保険合計';

--
-- Name: COLUMN ph_payment.dependent; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.dependent IS '扶養等の数';

--
-- Name: COLUMN ph_payment.income_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.income_tax IS '所得税額';

--
-- Name: COLUMN ph_payment.adjusted_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.adjusted_tax IS '調整税額';

--
-- Name: COLUMN ph_payment.insure_money; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insure_money IS '社会保険対象金銭';

--
-- Name: COLUMN ph_payment.insure_in_kind; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insure_in_kind IS '社会保険対象現物';

--
-- Name: COLUMN ph_payment.insure_fixed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insure_fixed IS '社会保険対象固定賃金';

--
-- Name: COLUMN ph_payment.insure_unemploy; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insure_unemploy IS '雇用保険対象額';

--
-- Name: COLUMN ph_payment.bonus_base; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.bonus_base IS '賞与計算対象額';

--
-- Name: COLUMN ph_payment.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insert_date IS '作成日';

--
-- Name: COLUMN ph_payment.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.insert_user IS '作成者';

--
-- Name: COLUMN ph_payment.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.update_date IS '更新日';

--
-- Name: COLUMN ph_payment.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN ph_payment.update_user IS '更新者';

DROP TABLE IF EXISTS pd_pay_time;
CREATE TABLE pd_pay_time (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount numeric(10,2) NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_pay_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_pay_time IS '給与明細勤怠部';

--
-- Name: COLUMN pd_pay_time.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.kcode IS '社員コード';

--
-- Name: COLUMN pd_pay_time.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.calc_date IS '計算年月';

--
-- Name: COLUMN pd_pay_time.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.detail_code IS '明細コード';

--
-- Name: COLUMN pd_pay_time.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.amount IS '明細値';

--
-- Name: COLUMN pd_pay_time.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.insert_date IS '作成日';

--
-- Name: COLUMN pd_pay_time.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.insert_user IS '作成者';

--
-- Name: COLUMN pd_pay_time.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.update_date IS '更新日';

--
-- Name: COLUMN pd_pay_time.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_time.update_user IS '更新者';

DROP TABLE IF EXISTS pd_pay_allowance;
CREATE TABLE pd_pay_allowance (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount integer NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode, calc_date, detail_code)
);

--
-- Name: TABLE pd_pay_allowance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_pay_allowance IS '給与明細支給部';

--
-- Name: COLUMN pd_pay_allowance.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.kcode IS '社員コード';

--
-- Name: COLUMN pd_pay_allowance.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.calc_date IS '計算年月';

--
-- Name: COLUMN pd_pay_allowance.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.detail_code IS '明細コード';

--
-- Name: COLUMN pd_pay_allowance.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.amount IS '明細値';

--
-- Name: COLUMN pd_pay_allowance.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.insert_date IS '作成日';

--
-- Name: COLUMN pd_pay_allowance.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.insert_user IS '作成者';

--
-- Name: COLUMN pd_pay_allowance.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.update_date IS '更新日';

--
-- Name: COLUMN pd_pay_allowance.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_allowance.update_user IS '更新者';



DROP TABLE IF EXISTS pd_pay_breakdown;
CREATE TABLE pd_pay_breakdown (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount numeric(10,2) NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_pay_breakdown; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_pay_breakdown IS '給与明細内訳部';

--
-- Name: COLUMN pd_pay_breakdown.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.kcode IS '社員コード';

--
-- Name: COLUMN pd_pay_breakdown.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.calc_date IS '計算年月';

--
-- Name: COLUMN pd_pay_breakdown.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.detail_code IS '明細コード';

--
-- Name: COLUMN pd_pay_breakdown.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.amount IS '明細値';

--
-- Name: COLUMN pd_pay_breakdown.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.insert_date IS '作成日';

--
-- Name: COLUMN pd_pay_breakdown.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.insert_user IS '作成者';

--
-- Name: COLUMN pd_pay_breakdown.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.update_date IS '更新日';

--
-- Name: COLUMN pd_pay_breakdown.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_breakdown.update_user IS '更新者';


DROP TABLE IF EXISTS pd_pay_deduction;
CREATE TABLE pd_pay_deduction (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount integer NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_pay_deduction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_pay_deduction IS '給与明細控除部';

--
-- Name: COLUMN pd_pay_deduction.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.kcode IS '社員コード';

--
-- Name: COLUMN pd_pay_deduction.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.calc_date IS '計算年月';

--
-- Name: COLUMN pd_pay_deduction.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.detail_code IS '明細コード';

--
-- Name: COLUMN pd_pay_deduction.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.amount IS '明細値';

--
-- Name: COLUMN pd_pay_deduction.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.insert_date IS '作成日';

--
-- Name: COLUMN pd_pay_deduction.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.insert_user IS '作成者';

--
-- Name: COLUMN pd_pay_deduction.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.update_date IS '更新日';

--
-- Name: COLUMN pd_pay_deduction.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_deduction.update_user IS '更新者';

DROP TABLE IF EXISTS pd_pay_sum;
CREATE TABLE pd_pay_sum (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount integer NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_pay_sum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_pay_sum IS '給与明細合計部';

--
-- Name: COLUMN pd_pay_sum.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.kcode IS '社員コード';

--
-- Name: COLUMN pd_pay_sum.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.calc_date IS '計算年月';

--
-- Name: COLUMN pd_pay_sum.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.detail_code IS '明細コード';

--
-- Name: COLUMN pd_pay_sum.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.amount IS '明細値';

--
-- Name: COLUMN pd_pay_sum.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.insert_date IS '作成日';

--
-- Name: COLUMN pd_pay_sum.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.insert_user IS '作成者';

--
-- Name: COLUMN pd_pay_sum.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.update_date IS '更新日';

--
-- Name: COLUMN pd_pay_sum.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pd_pay_sum.update_user IS '更新者';

DROP TABLE IF EXISTS pt_payment;

DROP TABLE IF EXISTS pi_payment;
CREATE TABLE pi_payment (
  kcode character varying(10) NOT NULL,
  calc_date date NOT NULL,
  detail_code character varying(8) NOT NULL,
  amount numeric(10,2) NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pi_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pi_payment IS '給与中間データ';

--
-- Name: COLUMN pi_payment.kcode; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.kcode IS '社員コード';

--
-- Name: COLUMN pi_payment.calc_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.calc_date IS '計算年月';

--
-- Name: COLUMN pi_payment.detail_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.detail_code IS '明細コード';

--
-- Name: COLUMN pi_payment.amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.amount IS '明細値';

--
-- Name: COLUMN pi_payment.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.insert_date IS '作成日';

--
-- Name: COLUMN pi_payment.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.insert_user IS '作成者';

--
-- Name: COLUMN pi_payment.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.update_date IS '更新日';

--
-- Name: COLUMN pi_payment.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN pi_payment.update_user IS '更新者';

DROP TABLE IF EXISTS cm_company;
CREATE TABLE cm_company (
  company_code character varying(4) NOT NULL,
  company_name character varying(32) NOT NULL,
  company_kana character varying(32) NOT NULL,
  company_fb_kana character varying(32) NOT NULL,
  enterpreneur character varying(16) NOT NULL,
  company_postal character varying(8) NOT NULL,
  company_address character varying(64) NOT NULL,
  company_fb_address character varying(64) NOT NULL,
  company_phone character varying(13) NOT NULL,
  com_health_premium_rate numeric(6,3) NOT NULL default 0,
  com_nursing_premium_rate numeric(6,3) NOT NULL default 0,
  com_pension_premium_rate numeric(6,3) NOT NULL default 0,
  com_fund_premium_rate numeric(6,3) NOT NULL default 0,
  com_unemploy_premium_rate numeric(6,3) NOT NULL default 0,
  health_premium_rate numeric(6,3) NOT NULL default 0,
  nursing_premium_rate numeric(6,3) NOT NULL default 0,
  pension_premium_rate numeric(6,3) NOT NULL default 0,
  fund_premium_rate numeric(6,3) NOT NULL default 0,
  unemploy_premium_rate numeric(6,3) NOT NULL default 0,
  fund_participation character varying(2) NOT NULL,
  station_no character varying(8) NOT NULL,
  dispose_no character varying(8) NOT NULL,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (company_code)
);
--
-- Name: TABLE cm_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_company IS '会社マスタ';

--
-- Name: COLUMN cm_company.company_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_code IS '会社コード';

--
-- Name: COLUMN cm_company.company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_name IS '会社名';

--
-- Name: COLUMN cm_company.company_kana; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_kana IS '会社ﾌﾘｶﾞﾅ';

--
-- Name: COLUMN cm_company.company_fb_kana; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_fb_kana IS '会社ﾌﾘｶﾞﾅ(FBデータ用)';

--
-- Name: COLUMN cm_company.enterpreneur; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.enterpreneur IS '事業主名';

--
-- Name: COLUMN cm_company.company_postal; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_postal IS '会社郵便番号';

--
-- Name: COLUMN cm_company.company_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_address IS '会社住所';

--
-- Name: COLUMN cm_company.company_fb_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_fb_address IS '会社住所(FBデータ用)';

--
-- Name: COLUMN cm_company.company_phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.company_phone IS '会社電話番号';

--
-- Name: COLUMN cm_company.com_health_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.com_health_premium_rate IS '健康保険料率合計';

--
-- Name: COLUMN cm_company.com_nursing_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.com_nursing_premium_rate IS '介護保険料率合計';

--
-- Name: COLUMN cm_company.com_pension_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.com_pension_premium_rate IS '厚生年金料率合計';

--
-- Name: COLUMN cm_company.com_fund_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.com_fund_premium_rate IS '厚生年金基金料率合計';

--
-- Name: COLUMN cm_company.com_unemploy_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.com_unemploy_premium_rate IS '雇用保険料率合計';

--
-- Name: COLUMN cm_company.health_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.health_premium_rate IS '健康保険料率(個人)';

--
-- Name: COLUMN cm_company.nursing_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.nursing_premium_rate IS '介護保険料率(個人)';

--
-- Name: COLUMN cm_company.pension_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.pension_premium_rate IS '厚生年金料率(個人)';

--
-- Name: COLUMN cm_company.fund_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.fund_premium_rate IS '厚生年金基金料率(個人)';

--
-- Name: COLUMN cm_company.unemploy_premium_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.unemploy_premium_rate IS '雇用保険料率(個人)';

--
-- Name: COLUMN cm_company.fund_participation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.fund_participation IS '厚生年金基金加入';

--
-- Name: COLUMN cm_company.station_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.station_no IS '署番号';

--
-- Name: COLUMN cm_company.dispose_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.dispose_no IS '整理番号';

--
-- Name: COLUMN cm_company.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.insert_date IS '作成日';

--
-- Name: COLUMN cm_company.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.insert_user IS '作成者';

--
-- Name: COLUMN cm_company.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.update_date IS '更新日';

--
-- Name: COLUMN cm_company.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_company.update_user IS '更新者';

DROP TABLE IF EXISTS cm_co_bank;
CREATE TABLE cm_co_bank (
  co_bank_code character varying(4) NOT NULL,
  bank_code character varying(4) NOT NULL,
  branch_code character varying(3) NOT NULL,
  account_type character varying(2) NOT NULL,
  account_no character varying(7) NOT NULL,
  delete_flag integer NOT NULL default 0,
  insert_date timestamp without time zone NOT NULL,
  insert_user character varying(10) NOT NULL,
  update_date timestamp without time zone NOT NULL,
  update_user character varying(10) NOT NULL,
  PRIMARY KEY  (co_bank_code)
);

--
-- Name: TABLE cm_co_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_co_bank IS '会社銀行マスタ保守';

--
-- Name: COLUMN cm_co_bank.co_bank_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.co_bank_code IS '会社銀行コード';

--
-- Name: COLUMN cm_co_bank.bank_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.bank_code IS '銀行コード';

--
-- Name: COLUMN cm_co_bank.branch_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.branch_code IS '支店コード';

--
-- Name: COLUMN cm_co_bank.account_type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.account_type IS '預金区分';

--
-- Name: COLUMN cm_co_bank.account_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.account_no IS '口座番号';

--
-- Name: COLUMN cm_co_bank.delete_flag; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.delete_flag IS '削除フラグ';

--
-- Name: COLUMN cm_co_bank.insert_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.insert_date IS '作成日';

--
-- Name: COLUMN cm_co_bank.insert_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.insert_user IS '作成者';

--
-- Name: COLUMN cm_co_bank.update_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.update_date IS '更新日';

--
-- Name: COLUMN cm_co_bank.update_user; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_co_bank.update_user IS '更新者';

--
-- Name: cm_income_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_income_tax;
CREATE TABLE cm_income_tax (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  inc_expected_date date NOT NULL default '1901-01-01',
  income_tax_type character varying(8) DEFAULT ''::character varying NOT NULL,
  adjustment_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_widow_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_handicap_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_student_type character varying(8) DEFAULT ''::character varying NOT NULL,
  spouse_intend_type character varying(8) DEFAULT ''::character varying NOT NULL,
  general_dependent integer DEFAULT 0 NOT NULL,
  specific_dependent integer DEFAULT 0 NOT NULL,
  elderly_dependent integer DEFAULT 0 NOT NULL,
  live_with_eld_rel integer DEFAULT 0 NOT NULL,
  live_with_handi_ge integer DEFAULT 0 NOT NULL,
  live_with_handi_sp integer DEFAULT 0 NOT NULL,
  live_with_handi_el integer DEFAULT 0 NOT NULL,
  live_with_handi_er integer DEFAULT 0 NOT NULL,
  general_handicap integer DEFAULT 0 NOT NULL,
  specific_handicap integer DEFAULT 0 NOT NULL,
  dependent_count integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,inc_expected_date)
);

--
-- Name: TABLE cm_income_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_income_tax IS '人事マスタ所得税部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.inc_expected_date IS '所得税適用年';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.income_tax_type IS '課税区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.adjustment_type IS '年末調整区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.self_widow_type IS '本人寡婦区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.self_handicap_type IS '本人障害区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.self_student_type IS '本人学生区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.spouse_intend_type IS '配偶者区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.general_dependent IS '一般扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.specific_dependent IS '特定扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.elderly_dependent IS '老人扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.live_with_eld_rel IS '同居老親等';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.live_with_handi_ge IS '同居特障一般';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.live_with_handi_sp IS '同居特障特定';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.live_with_handi_el IS '同居特障老人';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.live_with_handi_er IS '同居特障老親';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.general_handicap IS '一般障害者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.specific_handicap IS '特別障害者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.dependent_count IS '扶養等の数';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN cm_income_tax.update_user IS '更新者';

--
-- Name: cm_payment_means; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_payment_means;
CREATE TABLE cm_payment_means (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  means_sequence integer DEFAULT 0 NOT NULL,
  allowance_type character varying(8) DEFAULT ''::character varying NOT NULL,
  co_bank_code character varying(2) DEFAULT ''::character varying NOT NULL,
  paid_bank_code character varying(4) DEFAULT ''::character varying NOT NULL,
  paid_branch_code character varying(3) DEFAULT ''::character varying NOT NULL,
  account_type character varying(8) DEFAULT ''::character varying NOT NULL,
  account_no character varying(7) DEFAULT ''::character varying NOT NULL,
  holder_name character varying(16) DEFAULT ''::character varying NOT NULL,
  holder_kana character varying(16) DEFAULT ''::character varying NOT NULL,
  payment_means character varying(8) DEFAULT ''::character varying NOT NULL,
  amount_type character varying(8) DEFAULT ''::character varying NOT NULL,
  fixed_amount integer DEFAULT 0 NOT NULL,
  delete_flag integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,means_sequence)
);

--
-- Name: TABLE cm_payment_means; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_payment_means IS '人事マスタ支給方法部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.means_sequence IS '支給方法連番';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.allowance_type IS '支給区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.co_bank_code IS '会社銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.paid_bank_code IS '振込銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.paid_branch_code IS '振込銀行支店コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.account_type IS '預金区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.account_no IS '口座番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.holder_name IS '口座名義';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.holder_kana IS '口座名義ﾌﾘｶﾞﾅ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.payment_means IS '支給方法';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.amount_type IS '金額区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.fixed_amount IS '固定金額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means.update_user IS '更新者';

--
-- Name: cm_residence_tax; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_residence_tax;
CREATE TABLE cm_residence_tax (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  res_expected_date date NOT NULL default '1901-01-01',
  payment_city_code character varying(6) DEFAULT ''::character varying NOT NULL,
  submit_city_code character varying(6) DEFAULT ''::character varying NOT NULL,
  june_amount integer DEFAULT 0 NOT NULL,
  july_amount integer DEFAULT 0 NOT NULL,
  august_amount integer DEFAULT 0 NOT NULL,
  september_amount integer DEFAULT 0 NOT NULL,
  october_amount integer DEFAULT 0 NOT NULL,
  november_amount integer DEFAULT 0 NOT NULL,
  december_amount integer DEFAULT 0 NOT NULL,
  january_amount integer DEFAULT 0 NOT NULL,
  february_amount integer DEFAULT 0 NOT NULL,
  march_amount integer DEFAULT 0 NOT NULL,
  april_amount integer DEFAULT 0 NOT NULL,
  may_amount integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,res_expected_date)
);

--
-- Name: TABLE cm_residence_tax; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_residence_tax IS '人事マスタ住民税部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.res_expected_date IS '住民税適用年';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.payment_city_code IS '納付先市町村コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.submit_city_code IS '提出先市町村コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.june_amount IS '初回6月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.july_amount IS '7月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.august_amount IS '8月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.september_amount IS '9月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.october_amount IS '10月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.november_amount IS '11月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.december_amount IS '12月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.january_amount IS '1月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.february_amount IS '2月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.march_amount IS '3月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.april_amount IS '4月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.may_amount IS '5月分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_residence_tax.update_user IS '更新者';

--
-- Name: cm_soc_insurance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_soc_insurance;
CREATE TABLE cm_soc_insurance (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  ins_expected_date date NOT NULL default '1901-01-01',
  pension_type character varying(2) DEFAULT ''::character varying NOT NULL,
  parttime_type character varying(2) DEFAULT ''::character varying NOT NULL,
  employee_type character varying(2) DEFAULT ''::character varying NOT NULL,
  calc_ins_type character varying(2) DEFAULT ''::character varying NOT NULL,
  nursing_ins_type character varying(2) DEFAULT ''::character varying NOT NULL,
  calc_unemploy_type character varying(2) DEFAULT ''::character varying NOT NULL,
  bonus_health_type character varying(2) DEFAULT ''::character varying NOT NULL,
  bonus_pension_type character varying(2) DEFAULT ''::character varying NOT NULL,
  health_no character varying(7) DEFAULT ''::character varying NOT NULL,
  health_payment integer DEFAULT 0 NOT NULL,
  health_get_date date default NULL,
  health_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  health_lost_date date default NULL,
  pension_no character varying(10) DEFAULT ''::character varying NOT NULL,
  pension_payment integer DEFAULT 0 NOT NULL,
  pension_get_date date default NULL,
  pension_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  pension_lost_date date default NULL,
  fund_no character varying(10) DEFAULT ''::character varying NOT NULL,
  fund_get_date date default NULL,
  unemploy_no character varying(13) DEFAULT ''::character varying NOT NULL,
  unemploy_get_date date default NULL,
  unemploy_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  unemploy_lost_date date default NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,ins_expected_date)
);

--
-- Name: TABLE cm_soc_insurance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_soc_insurance IS '人事マスタ社会保険部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.ins_expected_date IS '社会保険適用年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_type IS '厚生年金種別';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.parttime_type IS 'パート区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.employee_type IS '従業員区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.calc_ins_type IS '社会保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.nursing_ins_type IS '介護保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.calc_unemploy_type IS '雇用保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.bonus_health_type IS '健康保険賞与区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.bonus_pension_type IS '厚生年金賞与区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.health_no IS '健康保険番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.health_payment IS '健康保険標準報酬月額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.health_get_date IS '健康保険資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.health_lost_type IS '健康保険資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.health_lost_date IS '健康保険資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_no IS '厚生年金整理番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_payment IS '厚生年金標準報酬月額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_get_date IS '厚生年金資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_lost_type IS '厚生年金資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.pension_lost_date IS '厚生年金資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.fund_no IS '厚生年金基金加入番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.fund_get_date IS '厚生年金基金資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.unemploy_no IS '雇用保険番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.unemploy_get_date IS '雇用保険資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.unemploy_lost_type IS '雇用保険資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.unemploy_lost_date IS '雇用保険資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance.update_user IS '更新者';

--
-- Name: cm_bank; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_bank;
CREATE TABLE cm_bank (
  bank_code character varying(4) DEFAULT ''::character varying NOT NULL,
  bank_name character varying(20) DEFAULT ''::character varying NOT NULL,
  bank_kana character varying(20) DEFAULT ''::character varying NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (bank_code)
);

--
-- Name: TABLE cm_bank; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_bank IS '銀行マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.bank_code IS '銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.bank_name IS '銀行名';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.bank_kana IS '銀行フリガナ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_bank.update_user IS '更新者';

--
-- Name: cm_branch; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_branch;
CREATE TABLE cm_branch (
  bank_code character varying(4) DEFAULT ''::character varying NOT NULL,
  branch_code character varying(3) DEFAULT ''::character varying NOT NULL,
  branch_name character varying(20) DEFAULT ''::character varying NOT NULL,
  branch_kana character varying(20) DEFAULT ''::character varying NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (bank_code,branch_code)
);

--
-- Name: TABLE cm_branch; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_branch IS '支店マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.bank_code IS '銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.branch_code IS '支店コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.branch_name IS '支店名';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.branch_kana IS '支店フリガナ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_branch.update_user IS '更新者';

--
-- Name: cm_city; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_city;
CREATE TABLE cm_city (
  city_code character varying(6) DEFAULT ''::character varying NOT NULL,
  city_name character varying(10) DEFAULT ''::character varying NOT NULL,
  city_kana character varying(20) DEFAULT ''::character varying NOT NULL,
  city_account character varying(14) DEFAULT ''::character varying NOT NULL,
  city_account_name1 character varying(8) DEFAULT ''::character varying NOT NULL,
  city_account_name2 character varying(8) DEFAULT ''::character varying NOT NULL,
  designated_number character varying(15) DEFAULT ''::character varying NOT NULL,
  co_bank_code character varying(4) DEFAULT ''::character varying NOT NULL,
  master_office character varying(15) DEFAULT ''::character varying NOT NULL,
  city_postal_code character varying(10) DEFAULT ''::character varying NOT NULL,
  city_address1 character varying(25) DEFAULT ''::character varying NOT NULL,
  city_address2 character varying(25) DEFAULT ''::character varying NOT NULL,
  city_office1 character varying(16) DEFAULT ''::character varying NOT NULL,
  city_office2 character varying(16) DEFAULT ''::character varying NOT NULL,
  city_phone character varying(17) DEFAULT ''::character varying NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (city_code)
);

--
-- Name: TABLE cm_city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_city IS '市町村マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_code IS '市町村コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_name IS '市町村名';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_kana IS '市町村カナ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_account IS '市町村口座番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_account_name1 IS '加入者1';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_account_name2 IS '加入者2';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.designated_number IS '指定番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.co_bank_code IS '会社銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.master_office IS '取りまとめ局';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_postal_code IS '市町村郵便番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_address1 IS '市町村住所1';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_address2 IS '市町村住所2';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_office1 IS '役場名1';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_office2 IS '役場名2';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.city_phone IS '市町村電話番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_city.update_user IS '更新者';

--
-- Name: cm_commutation; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_commutation;
CREATE TABLE cm_commutation (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  commute_sequence integer DEFAULT 0 NOT NULL,
  commute_type character varying(8) DEFAULT ''::character varying NOT NULL,
  payment_interval character varying(8) DEFAULT ''::character varying NOT NULL,
  lump_monthly_type character varying(8) DEFAULT ''::character varying NOT NULL,
  pay_start_month date NOT NULL default '1901-01-01',
  commute_distance numeric(5,2) NOT NULL default '0.00',
  commute_amount integer DEFAULT 0 NOT NULL,
  commute_tax_free integer DEFAULT 0 NOT NULL,
  commute_taxed integer DEFAULT 0 NOT NULL,
  delete_flag integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,commute_sequence)
);

--
-- Name: TABLE cm_commutation; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_commutation IS '人事マスタ通勤手当部';


--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_sequence IS '通勤手当連番';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_type IS '通勤手当区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.payment_interval IS '支給間隔';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.lump_monthly_type IS '一括区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.pay_start_month IS '支給開始月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_distance IS '片道距離';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_amount IS '通勤手当支給額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_tax_free IS '非課税通勤費';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.commute_taxed IS '課税通勤費';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_commutation.update_user IS '更新者';

--
-- Name: cm_unit_amount; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_unit_amount;
CREATE TABLE cm_unit_amount (
  k_code character varying(10) DEFAULT ''::character varying NOT NULL,
  unit_type character varying(8) DEFAULT ''::character varying NOT NULL,
  unit_amount numeric(10,2) NOT NULL default '0.00',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (k_code,unit_type)
);

--
-- Name: TABLE cm_unit_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_unit_amount IS '人事マスタ計算単価部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.k_code IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.unit_type IS '計算単価区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.unit_amount IS '計算単価';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount.update_user IS '更新者';

--
-- Name: pm_detail_pd; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS pm_detail_pd;
CREATE TABLE pm_detail_pd (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  leave_type smallint DEFAULT 0 NOT NULL,
  display_type smallint DEFAULT 0 NOT NULL,
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_pd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_pd IS '明細給与控除項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.leave_type IS '休職時控除区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pd.update_user IS '更新者';

--
-- Name: m_export_payment; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS m_export_payment;
CREATE TABLE m_export_payment (
  ename character varying(20) DEFAULT ''::character varying NOT NULL,
  efile character varying(20) DEFAULT ''::character varying NOT NULL,
  eline integer DEFAULT 0 NOT NULL,
  efid character varying(20) DEFAULT ''::character varying NOT NULL,
  eftype character varying(10) DEFAULT ''::character varying NOT NULL,
  efname character varying(50) DEFAULT ''::character varying NOT NULL,
  deleteflag integer DEFAULT 0 NOT NULL,
  adddt timestamp without time zone NOT NULL,
  addcd character varying(10) NOT NULL,
  upddt timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  updcd character varying(10) NOT NULL,
  PRIMARY KEY  (ename,efile,eline)
);

--
-- Name: TABLE m_export_payment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE m_export_payment IS 'エキスポートマスタ(給与)';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.ename IS '名称';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.efile IS 'ファイルID';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.eline IS '行';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.efid IS 'フィールドID';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.eftype IS 'フィールドTYPE';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.efname IS 'フィールド名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.deleteflag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.adddt IS '登録日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.addcd IS '登録者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.upddt IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  m_export_payment.updcd IS '更新者';

--
-- Name: pm_detail_ps; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_ps;
CREATE TABLE pm_detail_ps (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  display_type smallint DEFAULT 0 NOT NULL,
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_ps; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_ps IS '明細給与合計項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--


COMMENT ON COLUMN  pm_detail_ps.expression IS '計算式';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.edit_flag IS '編集可否フラグ';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--


COMMENT ON COLUMN  pm_detail_ps.delete_flag IS '削除フラグ';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ps.update_user IS '更新者';

--
-- Name: pm_detail_pt; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS pm_detail_pt;
CREATE TABLE pm_detail_pt (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  display_type smallint DEFAULT 0 NOT NULL,
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_pt; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_pt IS '明細給与勤怠項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pt.update_user IS '更新者';

--
-- Name: pm_detail_pa; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_pa;
CREATE TABLE pm_detail_pa (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  taxation_type smallint DEFAULT 0 NOT NULL,
  overtime_type smallint DEFAULT 0 NOT NULL,
  ue_ins_type smallint DEFAULT 0 NOT NULL,
  bonus_type smallint DEFAULT 0 NOT NULL,
  fixed_type smallint DEFAULT 0 NOT NULL,
  soc_ins_type smallint DEFAULT 0 NOT NULL,
  meal_type smallint DEFAULT 0 NOT NULL,
  leave_type smallint DEFAULT 0 NOT NULL,
  display_type smallint DEFAULT 0 NOT NULL,
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_pa; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_pa IS '明細給与支給項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.taxation_type IS '課税対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.overtime_type IS '残業対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.ue_ins_type IS '雇用保険対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.bonus_type IS '賞与対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.fixed_type IS '固定賃金区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.soc_ins_type IS '社会保険対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.meal_type IS '食事宿直区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.leave_type IS '休職時支給区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pa.update_user IS '更新者';

--
-- Name: pm_detail_pb; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_pb;
CREATE TABLE pm_detail_pb (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  upper_code character varying(8) DEFAULT ''::character varying NOT NULL,
  total_type smallint DEFAULT 0 NOT NULL,
  view_type smallint DEFAULT 0 NOT NULL,
  display_type smallint DEFAULT 0 NOT NULL,
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint DEFAULT 0 NOT NULL,
  edit_flag smallint DEFAULT 0 NOT NULL,
  delete_flag smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_pb; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_pb IS '明細給与内訳項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.upper_code IS '上位明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.total_type IS '集計区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.view_type IS '表示区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_pb.update_user IS '更新者';

--
-- Name: ps_slip; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS ps_slip;
CREATE TABLE ps_slip (
  slip_code character varying(4) DEFAULT ''::character varying NOT NULL,
  detail_type character varying(2) DEFAULT ''::character varying NOT NULL,
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  view_index smallint DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (slip_code,detail_type,detail_code)
);

--
-- Name: TABLE ps_slip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ps_slip IS '給賞与伝票明細設定';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.slip_code IS '伝票コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.detail_type IS '明細区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.view_index IS '表示順';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ps_slip.update_user IS '更新者';


--
-- Name: pd_bon_allowance; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS pd_bon_allowance;
CREATE TABLE pd_bon_allowance (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  calc_date date NOT NULL default '1971-01-01',
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  amount integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_bon_allowance; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_bon_allowance IS '賞与明細支給部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.calc_date IS '計算年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.amount IS '明細値';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_allowance.update_user IS '更新者';

--
-- Name: pd_bon_deduction; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS pd_bon_deduction;
CREATE TABLE pd_bon_deduction (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  calc_date date NOT NULL default '1971-01-01',
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  amount integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_bon_deduction; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_bon_deduction IS '賞与明細控除部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.calc_date IS '計算年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.amount IS '明細値';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_deduction.update_user IS '更新者';

--
-- Name: pd_bon_sum; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pd_bon_sum;
CREATE TABLE pd_bon_sum (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  calc_date date NOT NULL default '1971-01-01',
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  amount integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pd_bon_sum; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pd_bon_sum IS '賞与明細合計部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.calc_date IS '計算年月';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.amount IS '明細値';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pd_bon_sum.update_user IS '更新者';


--
-- Name: pi_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pi_bonus;
CREATE TABLE pi_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  calc_date date NOT NULL default '1971-01-01',
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  amount integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,calc_date,detail_code)
);

--
-- Name: TABLE pi_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pi_bonus IS '賞与中間データ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.kcode IS '社員コード';
--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.calc_date IS '計算年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.amount IS '明細値';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pi_bonus.update_user IS '更新者';

--
-- Name: pm_detail_ba; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_ba;
CREATE TABLE pm_detail_ba (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  taxation_type smallint NOT NULL default '0',
  overtime_type smallint NOT NULL default '0',
  ue_ins_type smallint NOT NULL default '0',
  bonus_type smallint NOT NULL default '0',
  fixed_type smallint NOT NULL default '0',
  soc_ins_type smallint NOT NULL default '0',
  meal_type smallint NOT NULL default '0',
  leave_type smallint NOT NULL default '0',
  display_type smallint NOT NULL default '0',
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint NOT NULL default '0',
  edit_flag smallint NOT NULL default '0',
  delete_flag smallint NOT NULL default '0',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_ba; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_ba IS '明細賞与支給項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.taxation_type IS '課税対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.overtime_type IS '残業対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.ue_ins_type IS '雇用保険対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.bonus_type IS '賞与対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.fixed_type IS '固定賃金区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.soc_ins_type IS '社会保険対象区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.meal_type IS '食事宿直区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.leave_type IS '休職時支給区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_ba.update_user IS '更新者';

--
-- Name: pm_detail_bd; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_bd;
CREATE TABLE pm_detail_bd (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  leave_type smallint NOT NULL default '0',
  display_type smallint NOT NULL default '0',
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint NOT NULL default '0',
  edit_flag smallint NOT NULL default '0',
  delete_flag smallint NOT NULL default '0',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_bd; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_bd IS '明細賞与控除項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.leave_type  IS '休職時支給区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bd.update_user IS '更新者';

--
-- Name: pm_detail_bs; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_detail_bs;
CREATE TABLE pm_detail_bs (
  detail_code character varying(8) DEFAULT ''::character varying NOT NULL,
  detail_name character varying(32) DEFAULT ''::character varying NOT NULL,
  detail_abbr character varying(6) DEFAULT ''::character varying NOT NULL,
  display_type smallint NOT NULL default '0',
  expression character varying(255) DEFAULT ''::character varying NOT NULL,
  input_type smallint NOT NULL default '0',
  edit_flag smallint NOT NULL default '0',
  delete_flag smallint NOT NULL default '0',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (detail_code)
);

--
-- Name: TABLE pm_detail_bs; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_detail_bs IS '明細賞与合計項目マスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.detail_code IS '明細コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.detail_name IS '明細名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.detail_abbr IS '明細略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.display_type IS '0印字区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.expression IS '計算式';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.input_type IS '入力区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_detail_bs.update_user IS '更新者';

--
-- Name: ph_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS ph_bonus;
CREATE TABLE ph_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  calc_date date NOT NULL default '1971-01-01',
  pay_date date NOT NULL default '1971-01-01',
  slip_code character varying(8) DEFAULT ''::character varying NOT NULL,
  allowance_total integer DEFAULT 0 NOT NULL,
  deduction_total integer DEFAULT 0 NOT NULL,
  payment_total integer DEFAULT 0 NOT NULL,
  taxation integer DEFAULT 0 NOT NULL,
  soc_ins_total integer DEFAULT 0 NOT NULL,
  dependent smallint NOT NULL default '0',
  income_tax integer DEFAULT 0 NOT NULL,
  adjusted_tax integer DEFAULT 0 NOT NULL,
  insure_money integer DEFAULT 0 NOT NULL,
  insure_in_kind integer DEFAULT 0 NOT NULL,
  insure_fixed integer DEFAULT 0 NOT NULL,
  insure_unemploy integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,calc_date)
);

--
-- Name: TABLE ph_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE ph_bonus IS '賞与ヘッダー';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.calc_date IS '計算年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.pay_date IS '支給日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.slip_code IS '伝票コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.allowance_total IS '総支給金額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.deduction_total IS '総控除金額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.payment_total IS '差引支給額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.taxation IS '課税支給額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.soc_ins_total IS '社会保険合計';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.dependent IS '扶養等の数';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.income_tax IS '所得税額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.adjusted_tax IS '調整税額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insure_money IS '社会保険対象金銭';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insure_in_kind IS '社会保険対象現物';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insure_fixed IS '社会保険対象固定賃金';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insure_unemploy IS '社会保険対象額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  ph_bonus.update_user IS '更新者';

--
-- Name: cm_income_tax_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_income_tax_bonus;
CREATE TABLE cm_income_tax_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  inc_expected_date date NOT NULL default '1971-01-01',
  income_tax_type character varying(8) DEFAULT ''::character varying NOT NULL,
  adjustment_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_widow_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_handicap_type character varying(8) DEFAULT ''::character varying NOT NULL,
  self_student_type character varying(8) DEFAULT ''::character varying NOT NULL,
  spouse_intend_type character varying(8) DEFAULT ''::character varying NOT NULL,
  general_dependent integer DEFAULT 0 NOT NULL,
  specific_dependent integer DEFAULT 0 NOT NULL,
  elderly_dependent integer DEFAULT 0 NOT NULL,
  live_with_eld_rel integer DEFAULT 0 NOT NULL,
  live_with_handi_ge integer DEFAULT 0 NOT NULL,
  live_with_handi_sp integer DEFAULT 0 NOT NULL,
  live_with_handi_el integer DEFAULT 0 NOT NULL,
  live_with_handi_er integer DEFAULT 0 NOT NULL,
  general_handicap integer DEFAULT 0 NOT NULL,
  specific_handicap integer DEFAULT 0 NOT NULL,
  dependent_count integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,inc_expected_date)
);

--
-- Name: TABLE cm_income_tax_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_income_tax_bonus IS '人事マスタ賞与所得税部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.inc_expected_date IS '所得税適用年';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.income_tax_type IS '課税区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.adjustment_type IS '年末調整区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.self_widow_type IS '本人寡婦区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.self_handicap_type IS '本人障害区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.self_student_type IS '本人学生区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.spouse_intend_type IS '配属者区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.general_dependent IS '一般扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.specific_dependent IS '特定扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.elderly_dependent IS '老人扶養親族';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.live_with_eld_rel IS '同居老親等';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.live_with_handi_ge IS '同居特障一般';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.live_with_handi_sp IS '同居特障特定';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.live_with_handi_el IS '同居特障老人';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.live_with_handi_er IS '同居特障老親';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.general_handicap IS '一般障害者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.specific_handicap IS '特別障害者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.dependent_count IS '扶養等の数';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_income_tax_bonus.update_user IS '更新者';

--
-- Name: cm_payment_means_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_payment_means_bonus;
CREATE TABLE cm_payment_means_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  means_sequence integer DEFAULT 0 NOT NULL,
  allowance_type character varying(8) DEFAULT ''::character varying NOT NULL,
  co_bank_code character varying(2) DEFAULT ''::character varying NOT NULL,
  paid_bank_code character varying(4) DEFAULT ''::character varying NOT NULL,
  paid_branch_code character varying(3) DEFAULT ''::character varying NOT NULL,
  account_type character varying(8) DEFAULT ''::character varying NOT NULL,
  account_no character varying(7) DEFAULT ''::character varying NOT NULL,
  holder_name character varying(16) DEFAULT ''::character varying NOT NULL,
  holder_kana character varying(16) DEFAULT ''::character varying NOT NULL,
  payment_means character varying(8) DEFAULT ''::character varying NOT NULL,
  amount_type character varying(8) DEFAULT ''::character varying NOT NULL,
  fixed_amount integer DEFAULT 0 NOT NULL,
  delete_flag integer DEFAULT 0 NOT NULL,
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,means_sequence)
);

--
-- Name: TABLE cm_payment_means_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_payment_means_bonus IS '人事マスタ賞与支給方法部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.means_sequence IS '支給方法連番';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.allowance_type IS '支給区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.co_bank_code IS '会社銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.paid_bank_code IS '振込銀行コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.paid_branch_code IS '振込銀行支店コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.account_type IS '預金区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.account_no IS '口座番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.holder_name IS '口座名義';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.holder_kana IS '口座名義ﾌﾘｶﾞﾅ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.payment_means IS '支給方法';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.amount_type IS '金額区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.fixed_amount IS '固定金額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_payment_means_bonus.update_user IS '更新者';

--
-- Name: cm_soc_insurance_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--
DROP TABLE IF EXISTS cm_soc_insurance_bonus;
CREATE TABLE cm_soc_insurance_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  ins_expected_date date NOT NULL default '1971-01-01',
  pension_type character varying(2) DEFAULT ''::character varying NOT NULL,
  parttime_type character varying(2) DEFAULT ''::character varying NOT NULL,
  employee_type character varying(2) DEFAULT ''::character varying NOT NULL,
  calc_ins_type character varying(2) DEFAULT ''::character varying NOT NULL,
  nursing_ins_type character varying(2) DEFAULT ''::character varying NOT NULL,
  calc_unemploy_type character varying(2) DEFAULT ''::character varying NOT NULL,
  bonus_health_type character varying(2) DEFAULT ''::character varying NOT NULL,
  bonus_pension_type character varying(2) DEFAULT ''::character varying NOT NULL,
  health_no character varying(7) DEFAULT ''::character varying NOT NULL,
  health_payment integer DEFAULT 0 NOT NULL,
  health_get_date date NOT NULL default '1971-01-01',
  health_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  health_lost_date date NOT NULL default '1971-01-01',
  pension_no character varying(10) DEFAULT ''::character varying NOT NULL,
  pension_payment integer DEFAULT 0 NOT NULL,
  pension_get_date date NOT NULL default '1971-01-01',
  pension_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  pension_lost_date date NOT NULL default '1971-01-01',
  fund_no character varying(10) DEFAULT ''::character varying NOT NULL,
  fund_get_date date NOT NULL default '1971-01-01',
  unemploy_no character varying(13) DEFAULT ''::character varying NOT NULL,
  unemploy_get_date date NOT NULL default '1971-01-01',
  unemploy_lost_type character varying(2) DEFAULT ''::character varying NOT NULL,
  unemploy_lost_date date NOT NULL default '1971-01-01',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,ins_expected_date)
);

--
-- Name: TABLE cm_soc_insurance_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_soc_insurance_bonus IS '人事マスタ賞与社会保険部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.ins_expected_date IS '社会保険適用年月';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_type IS '厚生年金種別';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.parttime_type IS 'パート区別';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.employee_type IS '従業員区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.calc_ins_type IS '社会保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.nursing_ins_type IS '介護保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.calc_unemploy_type IS '雇用保険区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.bonus_health_type IS '健康保険賞与区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.bonus_pension_type IS '厚生年金賞与区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.health_no IS '健康保険番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.health_payment IS '健康保険標準報酬月額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.health_get_date IS '健康保険資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.health_lost_type IS '健康保険資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.health_lost_date IS '健康保険資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_no IS '厚生年金整理番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_payment IS '厚生年金標準報酬月額';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_get_date IS '厚生年金資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_lost_type IS '厚生年金資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.pension_lost_date IS '厚生年金資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.fund_no IS '厚生年金基金加入番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.fund_get_date IS '厚生年金基金資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.unemploy_no IS '雇用保険番号';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.unemploy_get_date IS '雇用保険資格取得日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.unemploy_lost_type IS '雇用保険資格喪失区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.unemploy_lost_date IS '雇用保険資格喪失日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_soc_insurance_bonus.update_user IS '更新者';

--
-- Name: cm_unit_amount_bonus; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS cm_unit_amount_bonus;
CREATE TABLE cm_unit_amount_bonus (
  kcode character varying(10) DEFAULT ''::character varying NOT NULL,
  unit_type character varying(8) DEFAULT ''::character varying NOT NULL,
  unit_amount numeric(10,2) NOT NULL default '0',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (kcode,unit_type)
);

--
-- Name: TABLE cm_unit_amount_bonus; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE cm_unit_amount_bonus IS '人事マスタ賞与計算単価部';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.kcode IS '社員コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.unit_type IS '計算単価区分';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.unit_amount IS '計算単価';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  cm_unit_amount_bonus.update_user IS '更新者';

--
-- Name: pm_bonus_code; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

DROP TABLE IF EXISTS pm_bonus_code;
CREATE TABLE pm_bonus_code (
  code_id character varying(8) DEFAULT ''::character varying NOT NULL,
  code_code character varying(4) DEFAULT ''::character varying NOT NULL,
  code_name character varying(32) DEFAULT ''::character varying NOT NULL,
  code_abbr character varying(8) DEFAULT ''::character varying NOT NULL,
  view_index smallint NOT NULL default '0',
  delete_flag smallint NOT NULL default '0',
  edit_flag smallint NOT NULL default '0',
  insert_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  insert_user character varying(10) DEFAULT ''::character varying NOT NULL,
  update_date timestamp without time zone DEFAULT '1970-12-31 15:00:00'::timestamp without time zone NOT NULL,
  update_user character varying(10) DEFAULT ''::character varying NOT NULL,
  PRIMARY KEY  (code_id,code_code)
);

--
-- Name: TABLE pm_bonus_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE pm_bonus_code IS '賞与用コードマスタ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.code_id IS 'コードID';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.code_code IS 'コード';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.code_name IS 'コード名称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.code_abbr IS 'コード略称';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.view_index IS '表示順';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.delete_flag IS '削除フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.edit_flag IS '編集可否フラグ';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.insert_date IS '作成日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.insert_user IS '作成者';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.update_date IS '更新日';

--
-- Name: COLUMN xxxx.YYYY; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN  pm_bonus_code.update_user IS '更新者';


INSERT INTO PM_DETAIL_BA VALUES
('BA001','基本賞与  ','基本賞与  ',0,1,0,1,0,0,0,0,0,'[ BA001 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA002','成果賞与①','成果賞与①',0,1,0,1,0,0,0,0,0,'[ BA002 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA003','成果賞与②','成果賞与②',0,1,0,1,0,0,0,0,0,'[ BA003 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA004','他手当①','他手当①',0,1,0,1,0,0,0,0,0,'[ BA004 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA005','他手当②','他手当②',0,1,0,1,0,0,0,0,0,'[ BA005 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA006','他手当③','他手当③',0,1,0,1,0,0,0,0,0,'[ BA006 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA007','予備手当7 ','予備手当7 ',0,1,0,1,0,0,0,0,0,'[ BA007 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA008','予備手当8 ','予備手当8 ',0,1,0,1,0,0,0,0,0,'[ BA008 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA009','予備手当9 ','予備手当9 ',0,1,0,1,0,0,0,0,0,'[ BA009 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA010','予備手当10','予備手当10',0,1,0,1,0,0,0,0,0,'[ BA010 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA011','予備手当11','予備手当11',0,1,0,1,0,0,0,0,0,'[ BA011 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA012','予備手当12','予備手当12',0,1,0,1,0,0,0,0,0,'[ BA012 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA013','予備手当13','予備手当13',0,1,0,1,0,0,0,0,0,'[ BA013 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA014','予備手当14','予備手当14',0,1,0,1,0,0,0,0,0,'[ BA014 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA015','予備手当15','予備手当15',0,1,0,1,0,0,0,0,0,'[ BA015 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA016','予備手当16','予備手当16',0,1,0,1,0,0,0,0,0,'[ BA016 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA017','予備手当17','予備手当17',0,1,0,1,0,0,0,0,0,'[ BA017 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA018','予備手当18','予備手当18',0,1,0,1,0,0,0,0,0,'[ BA018 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA019','予備手当19','予備手当19',0,1,0,1,0,0,0,0,0,'[ BA019 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA020','予備手当20','予備手当20',0,1,0,1,0,0,0,0,0,'[ BA020 ]',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA021','予備手当21','予備手当21',0,1,0,1,0,0,0,0,0,'[ BA021 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA022','予備手当22','予備手当22',0,1,0,1,0,0,0,0,0,'[ BA022 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA023','予備手当23','予備手当23',0,1,0,1,0,0,0,0,0,'[ BA023 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA024','予備手当24','予備手当24',0,1,0,1,0,0,0,0,0,'[ BA024 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA025','予備手当25','予備手当25',0,1,0,1,0,0,0,0,0,'[ BA025 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA026','予備手当26','予備手当26',0,1,0,1,0,0,0,0,0,'[ BA026 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA027','予備手当27','予備手当27',0,1,0,1,0,0,0,0,0,'[ BA027 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA028','予備手当28','予備手当28',0,1,0,1,0,0,0,0,0,'[ BA028 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA029','予備手当29','予備手当29',0,1,0,1,0,0,0,0,0,'[ BA029 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA030','予備手当30','予備手当30',0,1,0,1,0,0,0,0,0,'[ BA030 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA031','予備手当31','予備手当31',0,1,0,1,0,0,0,0,0,'[ BA031 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA032','予備手当32','予備手当32',0,1,0,1,0,0,0,0,0,'[ BA032 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA033','予備手当33','予備手当33',0,1,0,1,0,0,0,0,0,'[ BA033 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA034','予備手当34','予備手当34',0,1,0,1,0,0,0,0,0,'[ BA034 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA035','予備手当35','予備手当35',0,1,0,1,0,0,0,0,0,'[ BA035 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA036','予備手当36','予備手当36',0,1,0,1,0,0,0,0,0,'[ BA036 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA037','予備手当37','予備手当37',0,1,0,1,0,0,0,0,0,'[ BA037 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA038','予備手当38','予備手当38',0,1,0,1,0,0,0,0,0,'[ BA038 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA039','予備手当39','予備手当39',0,1,0,1,0,0,0,0,0,'[ BA039 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA040','予備手当40','予備手当40',0,1,0,1,0,0,0,0,0,'[ BA040 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA041','予備手当41','予備手当41',0,1,0,1,0,0,0,0,0,'[ BA041 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA042','予備手当42','予備手当42',0,1,0,1,0,0,0,0,0,'[ BA042 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA043','予備手当43','予備手当43',0,1,0,1,0,0,0,0,0,'[ BA043 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA044','予備手当44','予備手当44',0,1,0,1,0,0,0,0,0,'[ BA044 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA045','予備手当45','予備手当45',0,1,0,1,0,0,0,0,0,'[ BA045 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA046','予備手当46','予備手当46',0,1,0,1,0,0,0,0,0,'[ BA046 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA047','予備手当47','予備手当47',0,1,0,1,0,0,0,0,0,'[ BA047 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA048','予備手当48','予備手当48',0,1,0,1,0,0,0,0,0,'[ BA048 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA049','予備手当49','予備手当49',0,1,0,1,0,0,0,0,0,'[ BA049 ]',1,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BA050','予備手当50','予備手当50',0,0,0,0,0,0,0,0,0,'[ BA050 ]',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_BD VALUES 
('BD001','健康保険料','健康保険料',0,0,' [ BD001 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD002','介護保険料','介護保険料',0,0,' [ BD002 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD003','厚生年金料','厚生年金料',0,0,' [ BD003 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD004','厚年基金料','厚年基金料',0,0,' [ BD004 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD005','雇用保険料','雇用保険料',0,0,' [ BD005 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD006','所得税'    ,'所得税'    ,0,0,' [ BD006 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD007','他控除1'   ,'他控除1'   ,0,0,' [ BD007 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD008','他控除2'   ,'他控除2'   ,0,0,' [ BD008 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD009','他控除3'   ,'他控除3'   ,0,0,' [ BD009 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD010','他控除4'   ,'他控除4'   ,0,0,' [ BD010 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD011','他控除5'   ,'他控除5'   ,0,0,' [ BD011 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD012','他控除6'   ,'他控除6'   ,0,0,' [ BD012 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD013','他控除7'   ,'他控除7'   ,0,0,' [ BD013 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD014','他控除8'   ,'他控除8'   ,0,0,' [ BD014 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD015','他控除9'   ,'他控除9'   ,0,0,' [ BD015 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD016','他控除10'  ,'他控除10'  ,0,0,' [ BD016 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD017','他控除11'  ,'他控除11'  ,0,0,' [ BD017 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD018','他控除12'  ,'他控除12'  ,0,0,' [ BD018 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD019','他控除13'  ,'他控除13'  ,0,0,' [ BD019 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD020','他控除14'  ,'他控除14'  ,0,0,' [ BD020 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD021','予備控除21','予備控除21',0,0,' [ BD021 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD022','予備控除22','予備控除22',0,0,' [ BD022 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD023','予備控除23','予備控除23',0,0,' [ BD023 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD024','予備控除24','予備控除24',0,0,' [ BD024 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD025','予備控除25','予備控除25',0,0,' [ BD025 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD026','予備控除26','予備控除26',0,0,' [ BD026 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD027','予備控除27','予備控除27',0,0,' [ BD027 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD028','予備控除28','予備控除28',0,0,' [ BD028 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD029','予備控除29','予備控除29',0,0,' [ BD029 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD030','予備控除30','予備控除30',0,0,' [ BD030 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD031','予備控除31','予備控除31',0,0,' [ BD031 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD032','予備控除32','予備控除32',0,0,' [ BD032 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD033','予備控除33','予備控除33',0,0,' [ BD033 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD034','予備控除34','予備控除34',0,0,' [ BD034 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD035','予備控除35','予備控除35',0,0,' [ BD035 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD036','予備控除36','予備控除36',0,0,' [ BD036 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD037','予備控除37','予備控除37',0,0,' [ BD037 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD038','予備控除38','予備控除38',0,0,' [ BD038 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD039','予備控除39','予備控除39',0,0,' [ BD039 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD040','予備控除40','予備控除40',0,0,' [ BD040 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD041','予備控除41','予備控除41',0,0,' [ BD041 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD042','予備控除42','予備控除42',0,0,' [ BD042 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD043','予備控除43','予備控除43',0,0,' [ BD043 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD044','予備控除44','予備控除44',0,0,' [ BD044 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD045','予備控除45','予備控除45',0,0,' [ BD045 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD046','予備控除46','予備控除46',0,0,' [ BD046 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD047','予備控除47','予備控除47',0,0,' [ BD047 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD048','予備控除48','予備控除48',0,0,' [ BD048 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD049','予備控除49','予備控除49',0,0,' [ BD049 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BD050','予備控除50','予備控除50',0,0,' [ BD050 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');

INSERT INTO PM_DETAIL_BS VALUES 
('BS001','総支給金額' ,'総支給金額' ,0,' [ BS001 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS002','総控除金額' ,'総控除金額' ,0,' [ BS002 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS003','差引支給額' ,'差引支給額' ,0,' [ BS003 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS011','銀行1振込額','銀行1振込額',0,' [ BS011 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS012','銀行2振込額','銀行2振込額',0,' [ BS012 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS013','現金支給額' ,'現金支給額' ,0,' [ BS013 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS021','予備合計21' ,'予備合計21' ,0,' [ BS021 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS022','予備合計22' ,'予備合計22' ,0,' [ BS022 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS023','予備合計23' ,'予備合計23' ,0,' [ BS023 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('BS024','予備合計24' ,'予備合計24' ,0,' [ BS024 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_PD VALUES 
('PD001','健康保険料','健康保険料',0,0,' [ PD001 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD002','介護保険料','介護保険料',0,0,' [ PD002 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD003','厚生年金料','厚生年金料',0,0,' [ PD003 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD004','厚年基金料','厚年基金料',0,0,' [ PD004 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD005','雇用保険料','雇用保険料',0,0,' [ PD005 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD006','所得税'    ,'所得税'    ,0,0,' [ PD006 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD007','住民税'    ,'住民税'    ,0,0,' [ PD007 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD008','他控除1'   ,'他控除1'   ,0,0,' [ PD008 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD009','他控除2'   ,'他控除2'   ,0,0,' [ PD009 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD010','他控除3'   ,'他控除3'   ,0,0,' [ PD010 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD011','他控除4'   ,'他控除4'   ,0,0,' [ PD011 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD012','他控除5'   ,'他控除5'   ,0,0,' [ PD012 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD013','他控除6'   ,'他控除6'   ,0,0,' [ PD013 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD014','他控除7'   ,'他控除7'   ,0,0,' [ PD014 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD015','他控除8'   ,'他控除8'   ,0,0,' [ PD015 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD016','他控除9'   ,'他控除9'   ,0,0,' [ PD016 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD017','他控除10'  ,'他控除10'  ,0,0,' [ PD017 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD018','他控除11'  ,'他控除11'  ,0,0,' [ PD018 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD019','他控除12'  ,'他控除12'  ,0,0,' [ PD019 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD020','他控除13'  ,'他控除13'  ,0,0,' [ PD020 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD021','予備控除21','予備控除21',0,0,' [ PD021 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD022','予備控除22','予備控除22',0,0,' [ PD022 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD023','予備控除23','予備控除23',0,0,' [ PD023 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD024','予備控除24','予備控除24',0,0,' [ PD024 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD025','予備控除25','予備控除25',0,0,' [ PD025 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD026','予備控除26','予備控除26',0,0,' [ PD026 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD027','予備控除27','予備控除27',0,0,' [ PD027 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD028','予備控除28','予備控除28',0,0,' [ PD028 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD029','予備控除29','予備控除29',0,0,' [ PD029 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD030','予備控除30','予備控除30',0,0,' [ PD030 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD031','予備控除31','予備控除31',0,0,' [ PD031 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD032','予備控除32','予備控除32',0,0,' [ PD032 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD033','予備控除33','予備控除33',0,0,' [ PD033 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD034','予備控除34','予備控除34',0,0,' [ PD034 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD035','予備控除35','予備控除35',0,0,' [ PD035 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD036','予備控除36','予備控除36',0,0,' [ PD036 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD037','予備控除37','予備控除37',0,0,' [ PD037 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD038','予備控除38','予備控除38',0,0,' [ PD038 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD039','予備控除39','予備控除39',0,0,' [ PD039 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD040','予備控除40','予備控除40',0,0,' [ PD040 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD041','予備控除41','予備控除41',0,0,' [ PD041 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD042','予備控除42','予備控除42',0,0,' [ PD042 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD043','予備控除43','予備控除43',0,0,' [ PD043 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD044','予備控除44','予備控除44',0,0,' [ PD044 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD045','予備控除45','予備控除45',0,0,' [ PD045 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD046','予備控除46','予備控除46',0,0,' [ PD046 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD047','予備控除47','予備控除47',0,0,' [ PD047 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD048','予備控除48','予備控除48',0,0,' [ PD048 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD049','予備控除49','予備控除49',0,0,' [ PD049 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PD050','予備控除50','予備控除50',0,0,' [ PD050 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_PS VALUES 
('PS001','総支給金額' ,'総支給金額' ,0,' [ PS001 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS002','総控除金額' ,'総控除金額' ,0,' [ PS002 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS003','差引支給額' ,'差引支給額' ,0,' [ PS003 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS011','銀行1振込額','銀行1振込額',0,' [ PS011 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS012','銀行2振込額','銀行2振込額',0,' [ PS012 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS013','現金支給額' ,'現金支給額' ,0,' [ PS013 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS021','予備合計21' ,'予備合計21' ,0,' [ PS021 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS022','予備合計22' ,'予備合計22' ,0,' [ PS022 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS023','予備合計23' ,'予備合計23' ,0,' [ PS023 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PS024','予備合計24' ,'予備合計24' ,0,' [ PS024 ] ',0,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_PT VALUES 
('PT001','出勤日数','出勤日数',0,' [ PT001 ] '               ,2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT002','出勤回数','出勤回数',0,' [ PT002 ] '               ,2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT003','勤務時間','勤務時間',0,' (R L,2, [ PT003 ] / 60 ) ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT004','残業時間','残業時間',0,' (R L,2, [ PT004 ] / 60 ) ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT005','深夜時間','深夜時間',0,' (R L,2, [ PT005 ] / 60 ) ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT006','休出時間','休出時間',0,' (R L,2, [ PT006 ] / 60 ) ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT007','遅早回数','遅早回数',0,' [ PT007 ] '               ,2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT008','遅早時間','遅早時間',0,' (R L,2, [ PT008 ] / 60 ) ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT009','有給'    ,'有給'    ,0,' [ PT009 ] '               ,2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT010','特別休暇','特別休暇',0,' [ PT010 ] '               ,2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT011','休憩時間'    ,'休憩時間'    ,0,' (R L,2, [ PT011 ] / 60 ) ',2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT012','一般欠勤日数','一般欠勤日数',0,' [ PT012 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT013','傷病欠勤日数','傷病欠勤日数',0,' [ PT013 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT014','代替休暇'    ,'代替休暇'    ,0,' [ PT014 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT015','振替休暇'    ,'振替休暇'    ,0,' [ PT015 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT016','その他休暇'  ,'その他休暇'  ,0,' [ PT016 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT017','二時間年休'  ,'二時間年休'  ,0,' [ PT017 ] '               ,2,1,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT018','予備勤怠18','予備勤怠18',0,' [ PT018 ] '           ,2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT019','予備勤怠19','予備勤怠19',0,' [ PT019 ] '           ,2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PT020','予備勤怠20','予備勤怠20',0,' [ PT020 ] '           ,2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_PA VALUES 
('PA001','基本給'    ,'基本給'    ,0,0,0,0,0,0,0,0,0,' [ PA001 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA002','職能給1'   ,'職能給1'   ,0,0,0,0,0,0,0,0,0,' [ PA002 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA003','職能給2'   ,'職能給2'   ,0,0,0,0,0,0,0,0,0,' [ PA003 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA004','残深休手当','残深休手当',0,0,0,0,0,0,0,0,0,' (R L,0, [ PT004 ] / 60 * [ PA0041 ] ) + (R L,0, [ PT005 ] / 60 * [ PA0042 ] ) + (R L,0, [ PT006 ] / 60 * [ PA0043 ] ) ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA005','他手当1'   ,'他手当1'   ,0,0,0,0,0,0,0,0,0,' [ PA005 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA006','他手当2'   ,'他手当2'   ,0,0,0,0,0,0,0,0,0,' [ PA006 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA007','精皆勤手当','精皆勤手当',0,0,0,0,0,0,0,0,0,' [ PA007 ] * [ PA0071 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA008','食事手当'  ,'食事手当'  ,1,0,0,0,0,0,0,0,0,' [ PA008 ] * [ PA0081 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA009','1直手当'   ,'1直手当'   ,1,0,0,0,0,0,0,0,0,' [ PA009 ] * [ PA0091 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA010','2直手当'   ,'2直手当'   ,1,0,0,0,0,0,0,0,0,' [ PA010 ] * [ PA0101 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA011','3直手当'   ,'3直手当'   ,1,0,0,0,0,0,0,0,0,' [ PA011 ] * [ PA0111 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA012','勤務手当1' ,'勤務手当1' ,0,0,0,0,0,0,0,0,0,' [ PA012 ] * [ PA0121 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA013','勤務手当2' ,'勤務手当2' ,0,0,0,0,0,0,0,0,0,' [ PA013 ] * [ PA0131 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA014','勤務手当3' ,'勤務手当3' ,0,0,0,0,0,0,0,0,0,' [ PA014 ] * [ PA0141 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA015','勤務手当4' ,'勤務手当4' ,0,0,0,0,0,0,0,0,0,' [ PA015 ] * [ PA0151 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA016','勤務手当5' ,'勤務手当5' ,0,0,0,0,0,0,0,0,0,' [ PA016 ] * [ PA0161 ] ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA017','申請手当'  ,'申請手当'  ,0,0,0,0,0,0,0,0,0,' [ PA017 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA018','通勤手当'  ,'通勤手当'  ,1,0,0,0,0,0,0,0,0,' [ PA018 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA019','他手当3'   ,'他手当3'   ,0,0,0,0,0,0,0,0,0,' [ PA019 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA020','他手当4'   ,'他手当4'   ,0,0,0,0,0,0,0,0,0,' [ PA020 ] ',1,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA021','予備手当21','予備手当21',0,0,0,0,0,0,0,0,0,' [ PA021 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA022','予備手当22','予備手当22',0,0,0,0,0,0,0,0,0,' [ PA022 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA023','予備手当23','予備手当23',0,0,0,0,0,0,0,0,0,' [ PA023 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA024','予備手当24','予備手当24',0,0,0,0,0,0,0,0,0,' [ PA024 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA025','予備手当25','予備手当25',0,0,0,0,0,0,0,0,0,' [ PA025 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA026','予備手当26','予備手当26',0,0,0,0,0,0,0,0,0,' [ PA026 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA027','予備手当27','予備手当27',0,0,0,0,0,0,0,0,0,' [ PA027 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA028','予備手当28','予備手当28',0,0,0,0,0,0,0,0,0,' [ PA028 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA029','予備手当29','予備手当29',0,0,0,0,0,0,0,0,0,' [ PA029 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA030','予備手当30','予備手当30',0,0,0,0,0,0,0,0,0,' [ PA030 ] ',1,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA031','予備手当31','予備手当31',0,0,0,0,0,0,0,0,0,' [ PA031 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA032','予備手当32','予備手当32',0,0,0,0,0,0,0,0,0,' [ PA032 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA033','予備手当33','予備手当33',0,0,0,0,0,0,0,0,0,' [ PA033 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA034','予備手当34','予備手当34',0,0,0,0,0,0,0,0,0,' [ PA034 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA035','予備手当35','予備手当35',0,0,0,0,0,0,0,0,0,' [ PA035 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA036','予備手当36','予備手当36',0,0,0,0,0,0,0,0,0,' [ PA036 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA037','予備手当37','予備手当37',0,0,0,0,0,0,0,0,0,' [ PA037 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA038','予備手当38','予備手当38',0,0,0,0,0,0,0,0,0,' [ PA038 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA039','予備手当39','予備手当39',0,0,0,0,0,0,0,0,0,' [ PA039 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA040','予備手当40','予備手当40',0,0,0,0,0,0,0,0,0,' [ PA040 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA041','予備手当41','予備手当41',0,0,0,0,0,0,0,0,0,' [ PA041 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA042','予備手当42','予備手当42',0,0,0,0,0,0,0,0,0,' [ PA042 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA043','予備手当43','予備手当43',0,0,0,0,0,0,0,0,0,' [ PA043 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA044','予備手当44','予備手当44',0,0,0,0,0,0,0,0,0,' [ PA044 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA045','予備手当45','予備手当45',0,0,0,0,0,0,0,0,0,' [ PA045 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA046','予備手当46','予備手当46',0,0,0,0,0,0,0,0,0,' [ PA046 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA047','予備手当47','予備手当47',0,0,0,0,0,0,0,0,0,' [ PA047 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA048','予備手当48','予備手当48',0,0,0,0,0,0,0,0,0,' [ PA048 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA049','予備手当49','予備手当49',0,0,0,0,0,0,0,0,0,' [ PA049 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA050','予備手当50','予備手当50',0,0,0,0,0,0,0,0,0,' [ PA050 ] ',2,0,1,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
INSERT INTO PM_DETAIL_PB VALUES 
('PA0181','課税通勤手当','課税通勤手当','PA018',1,0,0,' [ PA0181 ] ',0,0,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0041','残業手当','残業手当','PA004',0,0,0,' (R L,0, [ PT004 ] / 60 * [ PA0041 ] ) ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0042','深夜手当','深夜手当','PA004',0,0,0,' (R L,0, [ PT005 ] / 60 * [ PA0042 ] ) ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0043','休出手当','休出手当','PA004',0,0,0,' (R L,0, [ PT006 ] / 60 * [ PA0043 ] ) ',1,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),

('PA0071','精皆勤回数','精皆勤回数','PA007',0,0,0,' [ PA0071 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0081','食事回数'  ,'食事回数'  ,'PA008',0,0,0,' [ PA0081 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0082','課税食事手当','課税食事手当','PA008',1,0,0,' [ PA0082 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0091','1直回数'   ,'1直回数'   ,'PA009',0,0,0,' [ PA0091 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0092','課税1直手当','課税1直手当','PA009',1,0,0,' [ PA0092 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0101','2直回数'   ,'2直回数'   ,'PA010',0,0,0,' [ PA0101 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0102','課税2直手当','課税2直手当','PA010',1,0,0,' [ PA0102 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0111','3直回数'   ,'3直回数'   ,'PA011',0,0,0,' [ PA0111 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0112','課税3直手当','課税3直手当','PA011',1,0,0,' [ PA0112 ] ',0,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0121','勤務回数1' ,'勤務回数1' ,'PA012',0,0,0,' [ PA0121 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0131','勤務回数2' ,'勤務回数2' ,'PA013',0,0,0,' [ PA0131 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0141','勤務回数3' ,'勤務回数3' ,'PA014',0,0,0,' [ PA0141 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0151','勤務回数4' ,'勤務回数4' ,'PA015',0,0,0,' [ PA0151 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('PA0161','勤務回数5' ,'勤務回数5' ,'PA016',0,0,0,' [ PA0161 ] ',2,1,0,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');


INSERT INTO PS_SLIP VALUES 
('****','PT','PT001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT004', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT005', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT006', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT007', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT008', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT009', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT010',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT011',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT012',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT013',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT014',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT015',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT016',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT017',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT018',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT019',19,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PT','PT020',20,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA004', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA005', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA006', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA007', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA008', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA009', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA010',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA011',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA012',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA013',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA014',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA015',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA016',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA017',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA018',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA019',19,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA020',20,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA021',21,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA022',22,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA023',23,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA024',24,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA025',25,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA026',26,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA027',27,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA028',28,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA029',29,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA030',30,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA031',31,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA032',32,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA033',33,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA034',34,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA035',35,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA036',36,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA037',37,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA038',38,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA039',39,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA040',40,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA041',41,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA042',42,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA043',43,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA044',44,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA045',45,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA046',46,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA047',47,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA048',48,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA049',49,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PA','PA050',50,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD004', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD005', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD006', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD007', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD008', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD009', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD010',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD011',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD012',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD013',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD014',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD015',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD016',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD017',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD018',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD019',19,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD020',20,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD021',21,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD022',22,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD023',23,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD024',24,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD025',25,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD026',26,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD027',27,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD028',28,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD029',29,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD030',30,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD031',31,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD032',32,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD033',33,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD034',34,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD035',35,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD036',36,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD037',37,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD038',38,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD039',39,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD040',40,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD041',41,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD042',42,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD043',43,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD044',44,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD045',45,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD046',46,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD047',47,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD048',48,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD049',49,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PD','PD050',50,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0041',1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0042',2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0043',3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0181',4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),

('****','PB','PA0071',5 ,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0081',6 ,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0082',7 ,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0091',8 ,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0092',9 ,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0101',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0102',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0111',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0112',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0121',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0131',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0141',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0151',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PB','PA0161',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),

('****','PS','PS001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS011', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS012', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS013', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS021', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS022', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS023', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('****','PS','PS024',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),

('B***','BA','BA001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA004', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA005', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA006', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA007', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA008', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA009', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA010',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA011',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA012',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA013',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA014',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA015',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA016',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA017',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA018',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA019',19,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA020',20,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA021',21,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA022',22,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA023',23,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA024',24,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA025',25,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA026',26,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA027',27,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA028',28,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA029',29,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA030',30,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA031',31,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA032',32,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA033',33,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA034',34,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA035',35,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA036',36,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA037',37,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA038',38,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA039',39,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA040',40,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA041',41,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA042',42,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA043',43,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA044',44,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA045',45,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA046',46,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA047',47,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA048',48,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA049',49,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BA','BA050',50,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD004', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD005', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD006', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD007', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD008', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD009', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD010',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD011',11,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD012',12,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD013',13,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD014',14,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD015',15,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD016',16,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD017',17,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD018',18,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD019',19,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD020',20,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD021',21,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD022',22,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD023',23,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD024',24,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD025',25,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD026',26,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD027',27,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD028',28,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD029',29,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD030',30,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD031',31,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD032',32,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD033',33,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD034',34,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD035',35,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD036',36,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD037',37,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD038',38,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD039',39,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD040',40,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD041',41,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD042',42,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD043',43,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD044',44,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD045',45,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD046',46,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD047',47,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD048',48,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD049',49,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BD','BD050',50,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS001', 1,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS002', 2,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS003', 3,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS011', 4,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS012', 5,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS013', 6,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS021', 7,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS022', 8,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS023', 9,'1971-01-01 00:00:00','','1971-01-01 00:00:00',''),
('B***','BS','BS024',10,'1971-01-01 00:00:00','','1971-01-01 00:00:00','');
